;windows_storeCurrentWindows(desktop)
;windows_showWindows(desktop)
;windows_hideWindows(desktop)
;windows_activateCorrectWindow(desktop)
;windows_moveWindowToDesktop(id, curDesktop, newDesktop)
;windows_removeWindowID(ID, desktop)
;SETTINGS
;omnipresentTaskbar := false 		...I would create a group defined by the class Shell_TrayWnd. There'd be special cases for when to hide it and when to show it.


DetectHiddenWindows, Off
debug := false
omnipresentTaskbar := true

;===== Initializations =====
curDesktop = 1
;the windows and active_id arrays must have each element initialized globally
windows1 = 
windows2 = 
windows3 =
windows4 =
active_id1 =
active_id2 =
active_id3 =
active_id4 =



windows_storeCurrentWindows(desktop)
{
   WinGet, active_id%desktop%, ID, A                      ; get the current active window
   emptyString =
   StringSplit, windows%desktop%, emptyString             ; Emiel: delete the entire windows_desktop_ array 
   WinGet, windows%desktop%, List,,, Program Manager      ; get list of all visible windows

   ;take special actions for specific windows
   Loop, % windows%desktop%
   {
	id := % windows%desktop%%A_Index%
	WinGetClass, windowClass, ahk_id %id%
	if windowClass = Shell_TrayWnd 		;This is the task bar;
	{ 	
		;if omnipresentTaskbar	<--a local variable
			windows%desktop%%A_Index%=      ;Empty the array element to keep the window visible on all desktops
		
		
	}
	else if windowClass = AutoHotkeyGUI		;Don't hide the AHK FlashSpaces Gui's visible
		windows%desktop%%A_Index%=
	else if windowClass = ROCKETDOCK			;Don't hide RocketDock	
		windows%desktop%%A_Index%=
	else if windowClass = RDIconWnd			;Don't hide RocketDock Icons
		windows%desktop%%A_Index%=
	else if windowClass = TForm2
		windows%desktop%%A_Index%=			;Don't hide RocketDock's Stack Docklet if it's open
	else if windowClass = SysShadow			;Important: shadows from tooltips, menus, and whatnot will get stuck if you switch before the tooltip/menu has properly closed
	{
		;tooltip A shadow has been detected. I'm killing it.
		;sleep 500
		;tooltip
		;sleep 200
		WinKill, ahk_class %windowClass%
	}
	  ;if windowClass = #32770            ; Emiel: we also want multimontaskbar on all virtual desktops
           ;windows%desktop%%A_Index%=      ; Emiel: just empty the array element, array will be emptied by next switch anyway
      ;if windowClass = cygwin/x X rl-xosview-XOsview-0   ; Emiel: xosviews e.d.
           ;windows%desktop%%A_Index%=      
      ;if windowClass = cygwin/x X rl-xosview-XOsview-1   ; Emiel: xosviews e.d.
           ;windows%desktop%%A_Index%=      
      ;if windowClass = MozillaUIWindowClass              ; Mozilla thunderbird
      ;{
        ;WinGet, ExStyle, ExStyle, ahk_id %id%
          ;if (ExStyle & 0x8)  ; 0x8 is WS_EX_TOPMOST.    ; Alleen de mailboxalertmelding!
		  ;windows%desktop%%A_Index%=      
      ;}
   }
   ;msgbox % "the windows list is: " . windows%desktop%
}

windows_showWindows(desktop)
{
   global windows
	;global i
	;msgbox % "(windows_showWindows)`rarray windows at desktop:" . desktop ", i:" . i . ", is " windows%desktop%%i% . "."
   
   Loop, % windows%desktop%
   {
		id := % windows%desktop%%A_Index%
		WinShow, ahk_id %id%
   }
}

windows_hideWindows(index)
{
   global windows

   Loop, % windows%index%
   {
		id := % windows%index%%A_Index%
		WinGetClass, class, ahk_id %id%
		WinHide, ahk_id %id%
   }
}

windows_activateCorrectWindow(desktop)
{
	activate_window := % active_id%desktop%
		;tooltip activating id %activate_window%.
		;sleep 1000
		;tooltip
    WinActivate ahk_id %activate_window%\
}

windows_moveWindowToDesktop(id, curDesktop, newDesktop)
{
	global
	;global windows	<--this fails to make the element added below global
	if (curDesktop <> newDesktop)
	{
		
		windows_removeWindowID(id, curDesktop)
		
		;add window to destination desktop
		windows%newDesktop% += 1
		local i := windows%newDesktop%	;I think i is the length of the sub-array
		windows%newDesktop%%i% := id
		
		;(debugging messages)
		;msgbox % "windows_moveWindowToDesktop(id, curDesktop, newDesktop)`r WINDOWS[" . newDesktop . "][" . i . "] = " . windows%newDesktop%%i% . "."
		;windows_displayElement(newDesktop, i)
		
		;hide window
		WinHide ahk_id %id%
		
		;WinMinimize, ahk_id %id%	;!!! This is a funky way to activate that topmost window after you hide the originally active window
		;DetectHiddenWindows On
		;WinRestore ahk_id %id%
		;WinHide, ahk_id %id%
		;DetectHiddenWindows Off
		
		;activate previous window
		;Send, {ALT DOWN}{TAB}{ALT UP}
		return i
	}
   
}

windows_displayElement(desktop, i)
{
	global 
	msgbox % "windows_displayElement(desktop, i)`r WINDOWS[" . desktop . "][" . i . "] = " . windows%desktop%%i% . "."
}

windows_setActiveWindow(id, desktop)
{
	global
	active_id%desktop% := id
}
windows_autosetActiveWindow(desktop)
{
	global
	lastElement := -1
	Loop, % windows%desktop%
	{
		lastElement := A_Index
	}
	if (lastElement != -1) {	
		Send, {Alt Down}{Tab}{Alt Up}	;activates the now topmost but yet unactive window. I don't really understand why this works but whatevs
		
		;store new active window's id
		WinGet, id, ID, A
		windows_setActiveWindow(id, newDesktop)
	}
}
	
windows_removeWindowID(ID, desktop)
{
	global windows
	loop, % windows%desktop%
	{
		if (windows%desktop%%A_Index% = ID)
		{
			 ;debug := windows%desktop%%A_Index%
			 ;msgbox removing this %debug%
			 windows%desktop%%A_Index%=      ;Emiel: just empty the array element, array will be emptied by next switch anyway
			 Break
		}
		;else msgbox found nothing at %A_Index%
	}
}	
	
windows_getActiveID(desktop)
{
	global
	return active_id%desktop%
}

windows_storeActiveID(desktop)
{
	WinGet, active_id%desktop%, ID, A
}

windows_deleteWindows(desktop)
{
	static windows	;is this necessary?
	emptyString = 
	StringSplit, windows%desktop%, emptyString
}

